#!/bin/bash

# Start Apache
sudo systemctl start apache2

# Automatically detect your current LAN IP (Wi-Fi router assigns this)
LOCAL_IP=$(hostname -I | awk '{print $1}')
SITE_URL="http://$LOCAL_IP/admin/login.php"

# Open in browser
xdg-open "$SITE_URL" 2>/dev/null || echo "Open this in your browser: $SITE_URL"

echo "==============================="
echo "🔐 Admin Login page is running at:"
echo "$SITE_URL"
echo "==============================="
