#!/bin/bash

# ========== Colors ==========
GREEN='\033[0;32m'
RED='\033[0;31m'
NC='\033[0m'

# ========== Clear Logs ==========
echo -e "${GREEN}[!] Clearing credentials logs and resetting IDs...${NC}"

# Database credentials
DB_USER="root"
DB_PASS="11223344"    # မင်း database password ကို ဒီမှာ ထည့်ပါ
DB_NAME="test_db"
TABLE_NAME="credentials"

# Confirmation
read -p "Are you sure you want to clear all logs? This cannot be undone. (y/n): " confirm
if [[ "$confirm" != "y" && "$confirm" != "Y" ]]; then
    echo "Operation cancelled."
    exit 0
fi

# Execute truncate table to clear logs and reset auto_increment
mysql -u "$DB_USER" -p"$DB_PASS" -D "$DB_NAME" -e "TRUNCATE TABLE $TABLE_NAME;"

if [ $? -eq 0 ]; then
    echo -e "${GREEN}[✔] Logs cleared and IDs reset.${NC}"
else
    echo -e "${RED}[✘] Failed to clear logs.${NC}"
fi

read -p "Press Enter to continue..."
