#!/bin/bash

DB_USER="root"
DB_PASS="11223344"  # ✅ YOUR MySQL root password
DB_NAME="test_db"
TABLE_NAME="credentials"

echo "[✔] Creating MySQL database '$DB_NAME' and table '$TABLE_NAME'..."

mysql -u $DB_USER -p$DB_PASS <<EOF
CREATE DATABASE IF NOT EXISTS $DB_NAME;
USE $DB_NAME;
CREATE TABLE IF NOT EXISTS $TABLE_NAME (
    id INT AUTO_INCREMENT PRIMARY KEY,
    email VARCHAR(255) NOT NULL,
    password VARCHAR(255) NOT NULL,
    ipaddress VARCHAR(45),
    user_agent TEXT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);
EOF

if [ $? -eq 0 ]; then
    echo "[✔] Database '$DB_NAME' and table '$TABLE_NAME' created successfully!"
else
    echo "[✘] Failed to create database or table."
fi
