#!/bin/bash

read -sp "Enter MySQL password: " MYSQL_PASS
echo ""

SECURE_DIR=$(mysql -u root -p"$MYSQL_PASS" -e "SHOW VARIABLES LIKE 'secure_file_priv';" | grep secure_file_priv | awk '{print $2}')

output_file="credentials_export_$(date +%Y%m%d_%H%M%S).csv"
output_path="${SECURE_DIR}${output_file}"

echo "[+] Exporting to $output_path ..."

mysql -u root -p"$MYSQL_PASS" -D test_db -e "SELECT id, email, password, ipaddress, user_agent, created_at INTO OUTFILE '$output_path' FIELDS TERMINATED BY ',' ENCLOSED BY '\"' LINES TERMINATED BY '\n' FROM credentials;"

if [ $? -eq 0 ]; then
    echo "[+] Export successful. Moving file to current directory..."
    sudo mv "$output_path" ./
    sudo chown $USER:$USER ./"$output_file"
    echo "[+] File moved to $(pwd)/$output_file"
else
    echo "[!] Export failed!"
fi
