#!/bin/bash

# Start Apache
sudo systemctl start apache2

# Get LAN IP
LOCAL_IP=$(hostname -I | awk '{print $1}')
SITE_URL="http://$LOCAL_IP/lucky-draw.php"

# Open in default browser (optional)
xdg-open "$SITE_URL" 2>/dev/null || echo "Open this in your browser: $SITE_URL"

echo "==============================="
echo "📲 Lucky Draw page is running on LAN at:"
echo "$SITE_URL"
echo "==============================="
