<?php
session_start();
// if (isset($_SESSION['admin_logged_in'])) {
//     header("Location: dashboard.php");
//     exit;
// }
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta http-equiv="Cache-Control" content="no-cache, no-store, must-revalidate"/>
  <meta http-equiv="Pragma" content="no-cache"/>
  <meta http-equiv="Expires" content="0"/>
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Admin Login</title>
  <style>
    * {
      box-sizing: border-box;
      margin: 0;
      padding: 0;
    }

    body {
      font-family: 'Segoe UI', sans-serif;
      background: linear-gradient(to right, #f8f9fa, #e9ecef);
      display: flex;
      justify-content: center;
      align-items: center;
      height: 100vh;
      animation: bodyFade 1s ease-in;
    }

    @keyframes bodyFade {
      from { opacity: 0; }
      to { opacity: 1; }
    }

    .login-box {
      background: white;
      padding: 40px;
      border-radius: 16px;
      box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
      width: 90%;
      max-width: 400px;
      animation: slideIn 0.8s ease;
    }

    @keyframes slideIn {
      from {
        transform: translateY(-30px);
        opacity: 0;
      }
      to {
        transform: translateY(0);
        opacity: 1;
      }
    }

    h2 {
      margin-bottom: 20px;
      color: #333;
      text-align: center;
    }

    label {
      display: block;
      margin-bottom: 6px;
      font-weight: 500;
    }

    input {
      width: 100%;
      padding: 10px 14px;
      margin-bottom: 20px;
      border: 1px solid #ccc;
      border-radius: 8px;
      outline: none;
      transition: border-color 0.3s;
      background-color: #fefefe;
    }

    input:focus {
      border-color: #007bff;
    }

    button {
      width: 100%;
      padding: 12px;
      background-color: #007bff;
      color: white;
      border: none;
      border-radius: 8px;
      font-size: 16px;
      cursor: pointer;
      transition: background-color 0.3s, transform 0.2s;
    }

    button:hover {
      background-color: #0056b3;
      transform: translateY(-2px);
    }

    @media (max-width: 500px) {
      .login-box {
        padding: 25px;
      }

      button {
        font-size: 15px;
      }
    }
  </style>
</head>
<body>
  <div class="login-box">
    <h2>Admin Login</h2>
    <form method="POST" action="auth.php" autocomplete="off">
      <input type="hidden" name="fakeusernameremembered"/>
      <input type="hidden" name="fakepasswordremembered"/>

      <label for="email">Email</label>
      <input
        type="email"
        id="email"
        name="email"
        required
        autocomplete="off"
        inputmode="email"
      />

      <label for="password">Password</label>
      <input
        type="password"
        id="password"
        name="password"
        required
        autocomplete="new-password"
      />

      <button type="submit">Login</button>
    </form>
  </div>
</body>
</html>
