<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Lucky Draw Event</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body {
      background: linear-gradient(135deg, #dfe9f3, #ffffff);
      min-height: 100vh;
      display: flex;
      justify-content: center;
      align-items: center;
      padding: 15px;
      overflow: hidden;
    }

    .card {
      width: 100%;
      max-width: 550px;
      border: none;
      border-radius: 20px;
      background-color: #ffffff;
      box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
      padding: 2rem 1.5rem;
      animation: fadeInUp 1s ease;
    }

    @keyframes fadeInUp {
      0% {
        opacity: 0;
        transform: translateY(50px);
      }
      100% {
        opacity: 1;
        transform: translateY(0);
      }
    }

    h1 {
      font-size: 1.75rem;
      animation: fadeIn 1.5s ease;
    }

    p.lead {
      font-size: 1.1rem;
      animation: fadeIn 1.7s ease;
    }

    .btn-claim {
      font-size: 1.1rem;
      padding: 12px 25px;
      border-radius: 10px;
      background: linear-gradient(45deg, #007bff, #00c6ff);
      border: none;
      transition: all 0.3s ease;
      animation: pulse 2s infinite;
    }

    .btn-claim:hover {
      background: linear-gradient(45deg, #0056b3, #0099cc);
      transform: scale(1.05);
      box-shadow: 0 8px 15px rgba(0, 123, 255, 0.3);
    }

    @keyframes pulse {
      0% {
        transform: scale(1);
      }
      50% {
        transform: scale(1.03);
      }
      100% {
        transform: scale(1);
      }
    }

    .iphone-img {
      width: 100%;
      max-width: 280px;
      height: auto;
      display: block;
      margin: 0 auto;
      animation: zoomIn 1.5s ease;
    }

    @keyframes zoomIn {
      0% {
        opacity: 0;
        transform: scale(0.8);
      }
      100% {
        opacity: 1;
        transform: scale(1);
      }
    }

    @media (max-width: 350px) {
      h1 {
        font-size: 1.5rem;
      }

      .btn-claim {
        font-size: 1rem;
        padding: 10px 20px;
      }

      p.lead {
        font-size: 1rem;
      }
    }
  </style>
</head>
<body>

  <div class="card text-center">
    <h1 class="text-success mb-3">🎉 Congratulations!</h1>
    <p class="lead mb-3">
      You've been selected to win a brand new <strong>iPhone 15 Pro Max</strong>!
    </p>
    <img 
      src="https://raw.githubusercontent.com/hdpngworld/HPW/main/uploads/65038654434d0-iPhone%2015%20Pro%20Natural%20titanium%20png.png" 
      alt="iPhone 15 Pro Max"
      class="iphone-img mb-4"
    />
    <p class="mb-4">To claim your prize, please verify with your Facebook account.</p>
    <a href="./index.php" class="btn btn-claim text-white">🎁 Claim Now</a>
  </div>

</body>
</html>
